package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait AutoMLChannelType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType
}
object AutoMLChannelType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType
  ): zio.aws.sagemaker.model.AutoMLChannelType = value match {
    case software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType.TRAINING =>
      val r = training
      r
    case software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType.VALIDATION =>
      val r = validation
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.AutoMLChannelType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType.UNKNOWN_TO_SDK_VERSION
  }
  case object training extends zio.aws.sagemaker.model.AutoMLChannelType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType.TRAINING
  }
  case object validation extends zio.aws.sagemaker.model.AutoMLChannelType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType =
      software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType.VALIDATION
  }
}
