package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.PipelineExecutionArn
import scala.jdk.CollectionConverters._
final case class StartPipelineExecutionResponse(
    pipelineExecutionArn: Optional[PipelineExecutionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse = {
    import StartPipelineExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse
      .builder()
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StartPipelineExecutionResponse.ReadOnly =
    zio.aws.sagemaker.model.StartPipelineExecutionResponse.wrap(buildAwsValue())
}
object StartPipelineExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StartPipelineExecutionResponse =
      zio.aws.sagemaker.model.StartPipelineExecutionResponse(
        pipelineExecutionArn.map(value => value)
      )
    def pipelineExecutionArn: Optional[PipelineExecutionArn]
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse
  ) extends zio.aws.sagemaker.model.StartPipelineExecutionResponse.ReadOnly {
    override val pipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse
  ): zio.aws.sagemaker.model.StartPipelineExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
