package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait SortBy {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.SortBy
}
object SortBy {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.SortBy
  ): zio.aws.sagemaker.model.SortBy = value match {
    case software.amazon.awssdk.services.sagemaker.model.SortBy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.SortBy.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.sagemaker.model.SortBy.CREATION_TIME =>
      val r = CreationTime
      r
    case software.amazon.awssdk.services.sagemaker.model.SortBy.STATUS =>
      val r = Status
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.SortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SortBy =
      software.amazon.awssdk.services.sagemaker.model.SortBy.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.sagemaker.model.SortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SortBy =
      software.amazon.awssdk.services.sagemaker.model.SortBy.NAME
  }
  case object CreationTime extends zio.aws.sagemaker.model.SortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SortBy =
      software.amazon.awssdk.services.sagemaker.model.SortBy.CREATION_TIME
  }
  case object Status extends zio.aws.sagemaker.model.SortBy {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SortBy =
      software.amazon.awssdk.services.sagemaker.model.SortBy.STATUS
  }
}
