package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MaximumRetryAttempts
import scala.jdk.CollectionConverters._
final case class RetryStrategy(maximumRetryAttempts: MaximumRetryAttempts) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RetryStrategy = {
    import RetryStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RetryStrategy
      .builder()
      .maximumRetryAttempts(
        MaximumRetryAttempts.unwrap(maximumRetryAttempts): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RetryStrategy.ReadOnly =
    zio.aws.sagemaker.model.RetryStrategy.wrap(buildAwsValue())
}
object RetryStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RetryStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RetryStrategy =
      zio.aws.sagemaker.model.RetryStrategy(maximumRetryAttempts)
    def maximumRetryAttempts: MaximumRetryAttempts
    def getMaximumRetryAttempts: ZIO[Any, Nothing, MaximumRetryAttempts] =
      ZIO.succeed(maximumRetryAttempts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RetryStrategy
  ) extends zio.aws.sagemaker.model.RetryStrategy.ReadOnly {
    override val maximumRetryAttempts: MaximumRetryAttempts =
      zio.aws.sagemaker.model.primitives
        .MaximumRetryAttempts(impl.maximumRetryAttempts())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RetryStrategy
  ): zio.aws.sagemaker.model.RetryStrategy.ReadOnly = new Wrapper(impl)
}
