package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.String8192
import scala.jdk.CollectionConverters._
final case class QueryLineageResponse(
    vertices: Optional[Iterable[zio.aws.sagemaker.model.Vertex]] =
      Optional.Absent,
    edges: Optional[Iterable[zio.aws.sagemaker.model.Edge]] = Optional.Absent,
    nextToken: Optional[String8192] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse = {
    import QueryLineageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse
      .builder()
      .optionallyWith(
        vertices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vertices)
      .optionallyWith(
        edges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.edges)
      .optionallyWith(
        nextToken.map(value => String8192.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.QueryLineageResponse.ReadOnly =
    zio.aws.sagemaker.model.QueryLineageResponse.wrap(buildAwsValue())
}
object QueryLineageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.QueryLineageResponse =
      zio.aws.sagemaker.model.QueryLineageResponse(
        vertices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        edges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vertices: Optional[List[zio.aws.sagemaker.model.Vertex.ReadOnly]]
    def edges: Optional[List[zio.aws.sagemaker.model.Edge.ReadOnly]]
    def nextToken: Optional[String8192]
    def getVertices
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Vertex.ReadOnly]] =
      AwsError.unwrapOptionField("vertices", vertices)
    def getEdges
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Edge.ReadOnly]] =
      AwsError.unwrapOptionField("edges", edges)
    def getNextToken: ZIO[Any, AwsError, String8192] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse
  ) extends zio.aws.sagemaker.model.QueryLineageResponse.ReadOnly {
    override val vertices
        : Optional[List[zio.aws.sagemaker.model.Vertex.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vertices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Vertex.wrap(item)
          }.toList
        )
    override val edges: Optional[List[zio.aws.sagemaker.model.Edge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Edge.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String8192] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.String8192(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse
  ): zio.aws.sagemaker.model.QueryLineageResponse.ReadOnly = new Wrapper(impl)
}
