package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{
  ServerlessMaxConcurrency,
  ServerlessMemorySizeInMB
}
import scala.jdk.CollectionConverters._
final case class ProductionVariantServerlessConfig(
    memorySizeInMB: ServerlessMemorySizeInMB,
    maxConcurrency: ServerlessMaxConcurrency
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig = {
    import ProductionVariantServerlessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig
      .builder()
      .memorySizeInMB(ServerlessMemorySizeInMB.unwrap(memorySizeInMB): Integer)
      .maxConcurrency(ServerlessMaxConcurrency.unwrap(maxConcurrency): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly =
    zio.aws.sagemaker.model.ProductionVariantServerlessConfig
      .wrap(buildAwsValue())
}
object ProductionVariantServerlessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProductionVariantServerlessConfig =
      zio.aws.sagemaker.model
        .ProductionVariantServerlessConfig(memorySizeInMB, maxConcurrency)
    def memorySizeInMB: ServerlessMemorySizeInMB
    def maxConcurrency: ServerlessMaxConcurrency
    def getMemorySizeInMB: ZIO[Any, Nothing, ServerlessMemorySizeInMB] =
      ZIO.succeed(memorySizeInMB)
    def getMaxConcurrency: ZIO[Any, Nothing, ServerlessMaxConcurrency] =
      ZIO.succeed(maxConcurrency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig
  ) extends zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly {
    override val memorySizeInMB: ServerlessMemorySizeInMB =
      zio.aws.sagemaker.model.primitives
        .ServerlessMemorySizeInMB(impl.memorySizeInMB())
    override val maxConcurrency: ServerlessMaxConcurrency =
      zio.aws.sagemaker.model.primitives
        .ServerlessMaxConcurrency(impl.maxConcurrency())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantServerlessConfig
  ): zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly =
    new Wrapper(impl)
}
