package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait Processor {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.Processor
}
object Processor {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.Processor
  ): zio.aws.sagemaker.model.Processor = value match {
    case software.amazon.awssdk.services.sagemaker.model.Processor.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.Processor.CPU =>
      val r = CPU
      r
    case software.amazon.awssdk.services.sagemaker.model.Processor.GPU =>
      val r = GPU
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.Processor {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Processor =
      software.amazon.awssdk.services.sagemaker.model.Processor.UNKNOWN_TO_SDK_VERSION
  }
  case object CPU extends zio.aws.sagemaker.model.Processor {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Processor =
      software.amazon.awssdk.services.sagemaker.model.Processor.CPU
  }
  case object GPU extends zio.aws.sagemaker.model.Processor {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.Processor =
      software.amazon.awssdk.services.sagemaker.model.Processor.GPU
  }
}
