package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  EntityDescription,
  ModelPackageGroupArn,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ModelPackageGroupSummary(
    modelPackageGroupName: EntityName,
    modelPackageGroupArn: ModelPackageGroupArn,
    modelPackageGroupDescription: Optional[EntityDescription] = Optional.Absent,
    creationTime: CreationTime,
    modelPackageGroupStatus: zio.aws.sagemaker.model.ModelPackageGroupStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummary = {
    import ModelPackageGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummary
      .builder()
      .modelPackageGroupName(
        EntityName.unwrap(modelPackageGroupName): java.lang.String
      )
      .modelPackageGroupArn(
        ModelPackageGroupArn.unwrap(modelPackageGroupArn): java.lang.String
      )
      .optionallyWith(
        modelPackageGroupDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .modelPackageGroupStatus(modelPackageGroupStatus.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly =
    zio.aws.sagemaker.model.ModelPackageGroupSummary.wrap(buildAwsValue())
}
object ModelPackageGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelPackageGroupSummary =
      zio.aws.sagemaker.model.ModelPackageGroupSummary(
        modelPackageGroupName,
        modelPackageGroupArn,
        modelPackageGroupDescription.map(value => value),
        creationTime,
        modelPackageGroupStatus
      )
    def modelPackageGroupName: EntityName
    def modelPackageGroupArn: ModelPackageGroupArn
    def modelPackageGroupDescription: Optional[EntityDescription]
    def creationTime: CreationTime
    def modelPackageGroupStatus: zio.aws.sagemaker.model.ModelPackageGroupStatus
    def getModelPackageGroupName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageGroupName)
    def getModelPackageGroupArn: ZIO[Any, Nothing, ModelPackageGroupArn] =
      ZIO.succeed(modelPackageGroupArn)
    def getModelPackageGroupDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageGroupDescription",
        modelPackageGroupDescription
      )
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getModelPackageGroupStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelPackageGroupStatus] =
      ZIO.succeed(modelPackageGroupStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummary
  ) extends zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly {
    override val modelPackageGroupName: EntityName =
      zio.aws.sagemaker.model.primitives
        .EntityName(impl.modelPackageGroupName())
    override val modelPackageGroupArn: ModelPackageGroupArn =
      zio.aws.sagemaker.model.primitives
        .ModelPackageGroupArn(impl.modelPackageGroupArn())
    override val modelPackageGroupDescription: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelPackageGroupDescription())
        .map(value =>
          zio.aws.sagemaker.model.primitives.EntityDescription(value)
        )
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val modelPackageGroupStatus
        : zio.aws.sagemaker.model.ModelPackageGroupStatus =
      zio.aws.sagemaker.model.ModelPackageGroupStatus
        .wrap(impl.modelPackageGroupStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummary
  ): zio.aws.sagemaker.model.ModelPackageGroupSummary.ReadOnly = new Wrapper(
    impl
  )
}
