package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ModelCardProcessingStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus
}
object ModelCardProcessingStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus
  ): zio.aws.sagemaker.model.ModelCardProcessingStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.DELETE_IN_PROGRESS =>
      val r = DeleteInProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.DELETE_PENDING =>
      val r = DeletePending
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.CONTENT_DELETED =>
      val r = ContentDeleted
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.EXPORT_JOBS_DELETED =>
      val r = ExportJobsDeleted
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.DELETE_COMPLETED =>
      val r = DeleteCompleted
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.DELETE_FAILED =>
      val r = DeleteFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelCardProcessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DeleteInProgress
      extends zio.aws.sagemaker.model.ModelCardProcessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.DELETE_IN_PROGRESS
  }
  case object DeletePending
      extends zio.aws.sagemaker.model.ModelCardProcessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.DELETE_PENDING
  }
  case object ContentDeleted
      extends zio.aws.sagemaker.model.ModelCardProcessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.CONTENT_DELETED
  }
  case object ExportJobsDeleted
      extends zio.aws.sagemaker.model.ModelCardProcessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.EXPORT_JOBS_DELETED
  }
  case object DeleteCompleted
      extends zio.aws.sagemaker.model.ModelCardProcessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.DELETE_COMPLETED
  }
  case object DeleteFailed
      extends zio.aws.sagemaker.model.ModelCardProcessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus =
      software.amazon.awssdk.services.sagemaker.model.ModelCardProcessingStatus.DELETE_FAILED
  }
}
