package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ModelArn,
  Timestamp,
  RoleArn,
  ModelName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Model(
    modelName: Optional[ModelName] = Optional.Absent,
    primaryContainer: Optional[zio.aws.sagemaker.model.ContainerDefinition] =
      Optional.Absent,
    containers: Optional[
      Iterable[zio.aws.sagemaker.model.ContainerDefinition]
    ] = Optional.Absent,
    inferenceExecutionConfig: Optional[
      zio.aws.sagemaker.model.InferenceExecutionConfig
    ] = Optional.Absent,
    executionRoleArn: Optional[RoleArn] = Optional.Absent,
    vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    modelArn: Optional[ModelArn] = Optional.Absent,
    enableNetworkIsolation: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Model = {
    import Model.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Model
      .builder()
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(primaryContainer.map(value => value.buildAwsValue()))(
        _.primaryContainer
      )
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        inferenceExecutionConfig.map(value => value.buildAwsValue())
      )(_.inferenceExecutionConfig)
      .optionallyWith(
        executionRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.executionRoleArn)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        modelArn.map(value => ModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Model.ReadOnly =
    zio.aws.sagemaker.model.Model.wrap(buildAwsValue())
}
object Model {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Model] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Model =
      zio.aws.sagemaker.model.Model(
        modelName.map(value => value),
        primaryContainer.map(value => value.asEditable),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inferenceExecutionConfig.map(value => value.asEditable),
        executionRoleArn.map(value => value),
        vpcConfig.map(value => value.asEditable),
        creationTime.map(value => value),
        modelArn.map(value => value),
        enableNetworkIsolation.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelName: Optional[ModelName]
    def primaryContainer
        : Optional[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]
    def containers
        : Optional[List[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]]
    def inferenceExecutionConfig
        : Optional[zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly]
    def executionRoleArn: Optional[RoleArn]
    def vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def creationTime: Optional[Timestamp]
    def modelArn: Optional[ModelArn]
    def enableNetworkIsolation: Optional[Boolean]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getPrimaryContainer: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ContainerDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("primaryContainer", primaryContainer)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ContainerDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getInferenceExecutionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceExecutionConfig",
      inferenceExecutionConfig
    )
    def getExecutionRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModelArn: ZIO[Any, AwsError, ModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Model
  ) extends zio.aws.sagemaker.model.Model.ReadOnly {
    override val modelName: Optional[ModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.sagemaker.model.primitives.ModelName(value))
    override val primaryContainer
        : Optional[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryContainer())
        .map(value => zio.aws.sagemaker.model.ContainerDefinition.wrap(value))
    override val containers
        : Optional[List[zio.aws.sagemaker.model.ContainerDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ContainerDefinition.wrap(item)
          }.toList
        )
    override val inferenceExecutionConfig
        : Optional[zio.aws.sagemaker.model.InferenceExecutionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceExecutionConfig())
        .map(value =>
          zio.aws.sagemaker.model.InferenceExecutionConfig.wrap(value)
        )
    override val executionRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val vpcConfig
        : Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modelArn: Optional[ModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.sagemaker.model.primitives.ModelArn(value))
    override val enableNetworkIsolation: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableNetworkIsolation())
        .map(value => value: Boolean)
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Model
  ): zio.aws.sagemaker.model.Model.ReadOnly = new Wrapper(impl)
}
