package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListNotebookInstanceLifecycleConfigsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    notebookInstanceLifecycleConfigs: Optional[
      Iterable[zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse = {
    import ListNotebookInstanceLifecycleConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        notebookInstanceLifecycleConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notebookInstanceLifecycleConfigs)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse
      .wrap(buildAwsValue())
}
object ListNotebookInstanceLifecycleConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse =
      zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse(
        nextToken.map(value => value),
        notebookInstanceLifecycleConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def notebookInstanceLifecycleConfigs: Optional[List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNotebookInstanceLifecycleConfigs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "notebookInstanceLifecycleConfigs",
      notebookInstanceLifecycleConfigs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse
  ) extends zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val notebookInstanceLifecycleConfigs: Optional[List[
      zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.notebookInstanceLifecycleConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.NotebookInstanceLifecycleConfigSummary
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse
  ): zio.aws.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
