package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  EntityName,
  MaxResults,
  Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListModelCardsRequest(
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nameContains: Optional[EntityName] = Optional.Absent,
    modelCardStatus: Optional[zio.aws.sagemaker.model.ModelCardStatus] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.ModelCardSortBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.ModelCardSortOrder] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest = {
    import ListModelCardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest
      .builder()
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nameContains.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(modelCardStatus.map(value => value.unwrap))(
        _.modelCardStatus
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListModelCardsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListModelCardsRequest.wrap(buildAwsValue())
}
object ListModelCardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelCardsRequest =
      zio.aws.sagemaker.model.ListModelCardsRequest(
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        maxResults.map(value => value),
        nameContains.map(value => value),
        modelCardStatus.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def maxResults: Optional[MaxResults]
    def nameContains: Optional[EntityName]
    def modelCardStatus: Optional[zio.aws.sagemaker.model.ModelCardStatus]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[zio.aws.sagemaker.model.ModelCardSortBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.ModelCardSortOrder]
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNameContains: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getModelCardStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCardStatus] =
      AwsError.unwrapOptionField("modelCardStatus", modelCardStatus)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCardSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCardSortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest
  ) extends zio.aws.sagemaker.model.ListModelCardsRequest.ReadOnly {
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nameContains: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelCardStatus
        : Optional[zio.aws.sagemaker.model.ModelCardStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCardStatus())
        .map(value => zio.aws.sagemaker.model.ModelCardStatus.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val sortBy: Optional[zio.aws.sagemaker.model.ModelCardSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.sagemaker.model.ModelCardSortBy.wrap(value))
    override val sortOrder
        : Optional[zio.aws.sagemaker.model.ModelCardSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.ModelCardSortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest
  ): zio.aws.sagemaker.model.ListModelCardsRequest.ReadOnly = new Wrapper(impl)
}
