package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListInferenceExperimentsResponse(
    inferenceExperiments: Optional[
      Iterable[zio.aws.sagemaker.model.InferenceExperimentSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse = {
    import ListInferenceExperimentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse
      .builder()
      .optionallyWith(
        inferenceExperiments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceExperiments)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListInferenceExperimentsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListInferenceExperimentsResponse
      .wrap(buildAwsValue())
}
object ListInferenceExperimentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListInferenceExperimentsResponse =
      zio.aws.sagemaker.model.ListInferenceExperimentsResponse(
        inferenceExperiments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def inferenceExperiments: Optional[
      List[zio.aws.sagemaker.model.InferenceExperimentSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getInferenceExperiments: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.InferenceExperimentSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inferenceExperiments", inferenceExperiments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse
  ) extends zio.aws.sagemaker.model.ListInferenceExperimentsResponse.ReadOnly {
    override val inferenceExperiments: Optional[
      List[zio.aws.sagemaker.model.InferenceExperimentSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceExperiments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.InferenceExperimentSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse
  ): zio.aws.sagemaker.model.ListInferenceExperimentsResponse.ReadOnly =
    new Wrapper(impl)
}
