package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListAutoMlJobsResponse(
    autoMLJobSummaries: Iterable[zio.aws.sagemaker.model.AutoMLJobSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse = {
    import ListAutoMlJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse
      .builder()
      .autoMLJobSummaries(autoMLJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListAutoMlJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListAutoMlJobsResponse.wrap(buildAwsValue())
}
object ListAutoMlJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListAutoMlJobsResponse =
      zio.aws.sagemaker.model.ListAutoMlJobsResponse(
        autoMLJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def autoMLJobSummaries
        : List[zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getAutoMLJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly
    ]] = ZIO.succeed(autoMLJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse
  ) extends zio.aws.sagemaker.model.ListAutoMlJobsResponse.ReadOnly {
    override val autoMLJobSummaries
        : List[zio.aws.sagemaker.model.AutoMLJobSummary.ReadOnly] = impl
      .autoMLJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AutoMLJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse
  ): zio.aws.sagemaker.model.ListAutoMlJobsResponse.ReadOnly = new Wrapper(impl)
}
