package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn
import scala.jdk.CollectionConverters._
final case class JupyterServerAppSettings(
    defaultResourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent,
    lifecycleConfigArns: Optional[Iterable[StudioLifecycleConfigArn]] =
      Optional.Absent,
    codeRepositories: Optional[
      Iterable[zio.aws.sagemaker.model.CodeRepository]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings = {
    import JupyterServerAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings
      .builder()
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .optionallyWith(
        lifecycleConfigArns.map(value =>
          value.map { item =>
            StudioLifecycleConfigArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.lifecycleConfigArns)
      .optionallyWith(
        codeRepositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeRepositories)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly =
    zio.aws.sagemaker.model.JupyterServerAppSettings.wrap(buildAwsValue())
}
object JupyterServerAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.JupyterServerAppSettings =
      zio.aws.sagemaker.model.JupyterServerAppSettings(
        defaultResourceSpec.map(value => value.asEditable),
        lifecycleConfigArns.map(value => value),
        codeRepositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def lifecycleConfigArns: Optional[List[StudioLifecycleConfigArn]]
    def codeRepositories
        : Optional[List[zio.aws.sagemaker.model.CodeRepository.ReadOnly]]
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
    def getLifecycleConfigArns
        : ZIO[Any, AwsError, List[StudioLifecycleConfigArn]] =
      AwsError.unwrapOptionField("lifecycleConfigArns", lifecycleConfigArns)
    def getCodeRepositories: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.CodeRepository.ReadOnly
    ]] = AwsError.unwrapOptionField("codeRepositories", codeRepositories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings
  ) extends zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly {
    override val defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultResourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
    override val lifecycleConfigArns: Optional[List[StudioLifecycleConfigArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleConfigArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn(item)
          }.toList
        )
    override val codeRepositories
        : Optional[List[zio.aws.sagemaker.model.CodeRepository.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeRepositories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.CodeRepository.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.JupyterServerAppSettings
  ): zio.aws.sagemaker.model.JupyterServerAppSettings.ReadOnly = new Wrapper(
    impl
  )
}
