package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageConfig(
    repositoryAccessMode: zio.aws.sagemaker.model.RepositoryAccessMode,
    repositoryAuthConfig: Optional[
      zio.aws.sagemaker.model.RepositoryAuthConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ImageConfig = {
    import ImageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ImageConfig
      .builder()
      .repositoryAccessMode(repositoryAccessMode.unwrap)
      .optionallyWith(repositoryAuthConfig.map(value => value.buildAwsValue()))(
        _.repositoryAuthConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ImageConfig.ReadOnly =
    zio.aws.sagemaker.model.ImageConfig.wrap(buildAwsValue())
}
object ImageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ImageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ImageConfig =
      zio.aws.sagemaker.model.ImageConfig(
        repositoryAccessMode,
        repositoryAuthConfig.map(value => value.asEditable)
      )
    def repositoryAccessMode: zio.aws.sagemaker.model.RepositoryAccessMode
    def repositoryAuthConfig
        : Optional[zio.aws.sagemaker.model.RepositoryAuthConfig.ReadOnly]
    def getRepositoryAccessMode
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.RepositoryAccessMode] =
      ZIO.succeed(repositoryAccessMode)
    def getRepositoryAuthConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RepositoryAuthConfig.ReadOnly
    ] = AwsError.unwrapOptionField("repositoryAuthConfig", repositoryAuthConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ImageConfig
  ) extends zio.aws.sagemaker.model.ImageConfig.ReadOnly {
    override val repositoryAccessMode
        : zio.aws.sagemaker.model.RepositoryAccessMode =
      zio.aws.sagemaker.model.RepositoryAccessMode
        .wrap(impl.repositoryAccessMode())
    override val repositoryAuthConfig
        : Optional[zio.aws.sagemaker.model.RepositoryAuthConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryAuthConfig())
        .map(value => zio.aws.sagemaker.model.RepositoryAuthConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ImageConfig
  ): zio.aws.sagemaker.model.ImageConfig.ReadOnly = new Wrapper(impl)
}
