package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait HubContentStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HubContentStatus
}
object HubContentStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HubContentStatus
  ): zio.aws.sagemaker.model.HubContentStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.HubContentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentStatus.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentStatus.IMPORTING =>
      val r = Importing
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentStatus.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentStatus.IMPORT_FAILED =>
      val r = ImportFailed
      r
    case software.amazon.awssdk.services.sagemaker.model.HubContentStatus.DELETE_FAILED =>
      val r = DeleteFailed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HubContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentStatus =
      software.amazon.awssdk.services.sagemaker.model.HubContentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Available extends zio.aws.sagemaker.model.HubContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentStatus =
      software.amazon.awssdk.services.sagemaker.model.HubContentStatus.AVAILABLE
  }
  case object Importing extends zio.aws.sagemaker.model.HubContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentStatus =
      software.amazon.awssdk.services.sagemaker.model.HubContentStatus.IMPORTING
  }
  case object Deleting extends zio.aws.sagemaker.model.HubContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentStatus =
      software.amazon.awssdk.services.sagemaker.model.HubContentStatus.DELETING
  }
  case object ImportFailed extends zio.aws.sagemaker.model.HubContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentStatus =
      software.amazon.awssdk.services.sagemaker.model.HubContentStatus.IMPORT_FAILED
  }
  case object DeleteFailed extends zio.aws.sagemaker.model.HubContentStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HubContentStatus =
      software.amazon.awssdk.services.sagemaker.model.HubContentStatus.DELETE_FAILED
  }
}
