package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionRoleIdentityConfig {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig
}
object ExecutionRoleIdentityConfig {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig
  ): zio.aws.sagemaker.model.ExecutionRoleIdentityConfig = value match {
    case software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig.USER_PROFILE_NAME =>
      val r = USER_PROFILE_NAME
      r
    case software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ExecutionRoleIdentityConfig {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig =
      software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig.UNKNOWN_TO_SDK_VERSION
  }
  case object USER_PROFILE_NAME
      extends zio.aws.sagemaker.model.ExecutionRoleIdentityConfig {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig =
      software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig.USER_PROFILE_NAME
  }
  case object DISABLED
      extends zio.aws.sagemaker.model.ExecutionRoleIdentityConfig {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig =
      software.amazon.awssdk.services.sagemaker.model.ExecutionRoleIdentityConfig.DISABLED
  }
}
