package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DescribeCodeRepositoryRequest(codeRepositoryName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest = {
    import DescribeCodeRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest
      .builder()
      .codeRepositoryName(
        EntityName.unwrap(codeRepositoryName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeCodeRepositoryRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeCodeRepositoryRequest.wrap(buildAwsValue())
}
object DescribeCodeRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeCodeRepositoryRequest =
      zio.aws.sagemaker.model.DescribeCodeRepositoryRequest(codeRepositoryName)
    def codeRepositoryName: EntityName
    def getCodeRepositoryName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(codeRepositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest
  ) extends zio.aws.sagemaker.model.DescribeCodeRepositoryRequest.ReadOnly {
    override val codeRepositoryName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.codeRepositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest
  ): zio.aws.sagemaker.model.DescribeCodeRepositoryRequest.ReadOnly =
    new Wrapper(impl)
}
