package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  AutoMLJobName,
  Timestamp,
  GenerateCandidateDefinitionsOnly,
  AutoMLFailureReason,
  AutoMLJobArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeAutoMlJobResponse(
    autoMLJobName: AutoMLJobName,
    autoMLJobArn: AutoMLJobArn,
    inputDataConfig: Iterable[zio.aws.sagemaker.model.AutoMLChannel],
    outputDataConfig: zio.aws.sagemaker.model.AutoMLOutputDataConfig,
    roleArn: RoleArn,
    autoMLJobObjective: Optional[zio.aws.sagemaker.model.AutoMLJobObjective] =
      Optional.Absent,
    problemType: Optional[zio.aws.sagemaker.model.ProblemType] =
      Optional.Absent,
    autoMLJobConfig: Optional[zio.aws.sagemaker.model.AutoMLJobConfig] =
      Optional.Absent,
    creationTime: Timestamp,
    endTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Timestamp,
    failureReason: Optional[AutoMLFailureReason] = Optional.Absent,
    partialFailureReasons: Optional[
      Iterable[zio.aws.sagemaker.model.AutoMLPartialFailureReason]
    ] = Optional.Absent,
    bestCandidate: Optional[zio.aws.sagemaker.model.AutoMLCandidate] =
      Optional.Absent,
    autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus,
    autoMLJobSecondaryStatus: zio.aws.sagemaker.model.AutoMLJobSecondaryStatus,
    generateCandidateDefinitionsOnly: Optional[
      GenerateCandidateDefinitionsOnly
    ] = Optional.Absent,
    autoMLJobArtifacts: Optional[zio.aws.sagemaker.model.AutoMLJobArtifacts] =
      Optional.Absent,
    resolvedAttributes: Optional[zio.aws.sagemaker.model.ResolvedAttributes] =
      Optional.Absent,
    modelDeployConfig: Optional[zio.aws.sagemaker.model.ModelDeployConfig] =
      Optional.Absent,
    modelDeployResult: Optional[zio.aws.sagemaker.model.ModelDeployResult] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse = {
    import DescribeAutoMlJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse
      .builder()
      .autoMLJobName(AutoMLJobName.unwrap(autoMLJobName): java.lang.String)
      .autoMLJobArn(AutoMLJobArn.unwrap(autoMLJobArn): java.lang.String)
      .inputDataConfig(inputDataConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(autoMLJobObjective.map(value => value.buildAwsValue()))(
        _.autoMLJobObjective
      )
      .optionallyWith(problemType.map(value => value.unwrap))(_.problemType)
      .optionallyWith(autoMLJobConfig.map(value => value.buildAwsValue()))(
        _.autoMLJobConfig
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        failureReason.map(value =>
          AutoMLFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        partialFailureReasons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partialFailureReasons)
      .optionallyWith(bestCandidate.map(value => value.buildAwsValue()))(
        _.bestCandidate
      )
      .autoMLJobStatus(autoMLJobStatus.unwrap)
      .autoMLJobSecondaryStatus(autoMLJobSecondaryStatus.unwrap)
      .optionallyWith(
        generateCandidateDefinitionsOnly.map(value =>
          GenerateCandidateDefinitionsOnly.unwrap(value): java.lang.Boolean
        )
      )(_.generateCandidateDefinitionsOnly)
      .optionallyWith(autoMLJobArtifacts.map(value => value.buildAwsValue()))(
        _.autoMLJobArtifacts
      )
      .optionallyWith(resolvedAttributes.map(value => value.buildAwsValue()))(
        _.resolvedAttributes
      )
      .optionallyWith(modelDeployConfig.map(value => value.buildAwsValue()))(
        _.modelDeployConfig
      )
      .optionallyWith(modelDeployResult.map(value => value.buildAwsValue()))(
        _.modelDeployResult
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeAutoMlJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeAutoMlJobResponse.wrap(buildAwsValue())
}
object DescribeAutoMlJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeAutoMlJobResponse =
      zio.aws.sagemaker.model.DescribeAutoMlJobResponse(
        autoMLJobName,
        autoMLJobArn,
        inputDataConfig.map { item =>
          item.asEditable
        },
        outputDataConfig.asEditable,
        roleArn,
        autoMLJobObjective.map(value => value.asEditable),
        problemType.map(value => value),
        autoMLJobConfig.map(value => value.asEditable),
        creationTime,
        endTime.map(value => value),
        lastModifiedTime,
        failureReason.map(value => value),
        partialFailureReasons.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bestCandidate.map(value => value.asEditable),
        autoMLJobStatus,
        autoMLJobSecondaryStatus,
        generateCandidateDefinitionsOnly.map(value => value),
        autoMLJobArtifacts.map(value => value.asEditable),
        resolvedAttributes.map(value => value.asEditable),
        modelDeployConfig.map(value => value.asEditable),
        modelDeployResult.map(value => value.asEditable)
      )
    def autoMLJobName: AutoMLJobName
    def autoMLJobArn: AutoMLJobArn
    def inputDataConfig: List[zio.aws.sagemaker.model.AutoMLChannel.ReadOnly]
    def outputDataConfig
        : zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly
    def roleArn: RoleArn
    def autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly]
    def problemType: Optional[zio.aws.sagemaker.model.ProblemType]
    def autoMLJobConfig
        : Optional[zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly]
    def creationTime: Timestamp
    def endTime: Optional[Timestamp]
    def lastModifiedTime: Timestamp
    def failureReason: Optional[AutoMLFailureReason]
    def partialFailureReasons: Optional[
      List[zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly]
    ]
    def bestCandidate
        : Optional[zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly]
    def autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus
    def autoMLJobSecondaryStatus
        : zio.aws.sagemaker.model.AutoMLJobSecondaryStatus
    def generateCandidateDefinitionsOnly
        : Optional[GenerateCandidateDefinitionsOnly]
    def autoMLJobArtifacts
        : Optional[zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly]
    def resolvedAttributes
        : Optional[zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly]
    def modelDeployConfig
        : Optional[zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly]
    def modelDeployResult
        : Optional[zio.aws.sagemaker.model.ModelDeployResult.ReadOnly]
    def getAutoMLJobName: ZIO[Any, Nothing, AutoMLJobName] =
      ZIO.succeed(autoMLJobName)
    def getAutoMLJobArn: ZIO[Any, Nothing, AutoMLJobArn] =
      ZIO.succeed(autoMLJobArn)
    def getInputDataConfig: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AutoMLChannel.ReadOnly
    ]] = ZIO.succeed(inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getAutoMLJobObjective: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobObjective", autoMLJobObjective)
    def getProblemType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProblemType] =
      AwsError.unwrapOptionField("problemType", problemType)
    def getAutoMLJobConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly] =
      AwsError.unwrapOptionField("autoMLJobConfig", autoMLJobConfig)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getFailureReason: ZIO[Any, AwsError, AutoMLFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getPartialFailureReasons: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly
    ]] =
      AwsError.unwrapOptionField("partialFailureReasons", partialFailureReasons)
    def getBestCandidate
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly] =
      AwsError.unwrapOptionField("bestCandidate", bestCandidate)
    def getAutoMLJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLJobStatus] =
      ZIO.succeed(autoMLJobStatus)
    def getAutoMLJobSecondaryStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLJobSecondaryStatus] =
      ZIO.succeed(autoMLJobSecondaryStatus)
    def getGenerateCandidateDefinitionsOnly
        : ZIO[Any, AwsError, GenerateCandidateDefinitionsOnly] =
      AwsError.unwrapOptionField(
        "generateCandidateDefinitionsOnly",
        generateCandidateDefinitionsOnly
      )
    def getAutoMLJobArtifacts: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly
    ] = AwsError.unwrapOptionField("autoMLJobArtifacts", autoMLJobArtifacts)
    def getResolvedAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("resolvedAttributes", resolvedAttributes)
    def getModelDeployConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly
    ] = AwsError.unwrapOptionField("modelDeployConfig", modelDeployConfig)
    def getModelDeployResult: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDeployResult.ReadOnly
    ] = AwsError.unwrapOptionField("modelDeployResult", modelDeployResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse
  ) extends zio.aws.sagemaker.model.DescribeAutoMlJobResponse.ReadOnly {
    override val autoMLJobName: AutoMLJobName =
      zio.aws.sagemaker.model.primitives.AutoMLJobName(impl.autoMLJobName())
    override val autoMLJobArn: AutoMLJobArn =
      zio.aws.sagemaker.model.primitives.AutoMLJobArn(impl.autoMLJobArn())
    override val inputDataConfig
        : List[zio.aws.sagemaker.model.AutoMLChannel.ReadOnly] = impl
      .inputDataConfig()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.AutoMLChannel.wrap(item)
      }
      .toList
    override val outputDataConfig
        : zio.aws.sagemaker.model.AutoMLOutputDataConfig.ReadOnly =
      zio.aws.sagemaker.model.AutoMLOutputDataConfig
        .wrap(impl.outputDataConfig())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val autoMLJobObjective
        : Optional[zio.aws.sagemaker.model.AutoMLJobObjective.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLJobObjective())
        .map(value => zio.aws.sagemaker.model.AutoMLJobObjective.wrap(value))
    override val problemType: Optional[zio.aws.sagemaker.model.ProblemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.problemType())
        .map(value => zio.aws.sagemaker.model.ProblemType.wrap(value))
    override val autoMLJobConfig
        : Optional[zio.aws.sagemaker.model.AutoMLJobConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLJobConfig())
        .map(value => zio.aws.sagemaker.model.AutoMLJobConfig.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val failureReason: Optional[AutoMLFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.sagemaker.model.primitives.AutoMLFailureReason(value)
        )
    override val partialFailureReasons: Optional[
      List[zio.aws.sagemaker.model.AutoMLPartialFailureReason.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.partialFailureReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AutoMLPartialFailureReason.wrap(item)
        }.toList
      )
    override val bestCandidate
        : Optional[zio.aws.sagemaker.model.AutoMLCandidate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bestCandidate())
        .map(value => zio.aws.sagemaker.model.AutoMLCandidate.wrap(value))
    override val autoMLJobStatus: zio.aws.sagemaker.model.AutoMLJobStatus =
      zio.aws.sagemaker.model.AutoMLJobStatus.wrap(impl.autoMLJobStatus())
    override val autoMLJobSecondaryStatus
        : zio.aws.sagemaker.model.AutoMLJobSecondaryStatus =
      zio.aws.sagemaker.model.AutoMLJobSecondaryStatus
        .wrap(impl.autoMLJobSecondaryStatus())
    override val generateCandidateDefinitionsOnly
        : Optional[GenerateCandidateDefinitionsOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.generateCandidateDefinitionsOnly())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .GenerateCandidateDefinitionsOnly(value)
      )
    override val autoMLJobArtifacts
        : Optional[zio.aws.sagemaker.model.AutoMLJobArtifacts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMLJobArtifacts())
        .map(value => zio.aws.sagemaker.model.AutoMLJobArtifacts.wrap(value))
    override val resolvedAttributes
        : Optional[zio.aws.sagemaker.model.ResolvedAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolvedAttributes())
        .map(value => zio.aws.sagemaker.model.ResolvedAttributes.wrap(value))
    override val modelDeployConfig
        : Optional[zio.aws.sagemaker.model.ModelDeployConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDeployConfig())
        .map(value => zio.aws.sagemaker.model.ModelDeployConfig.wrap(value))
    override val modelDeployResult
        : Optional[zio.aws.sagemaker.model.ModelDeployResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDeployResult())
        .map(value => zio.aws.sagemaker.model.ModelDeployResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse
  ): zio.aws.sagemaker.model.DescribeAutoMlJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
