package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{SpaceName, DomainId}
import scala.jdk.CollectionConverters._
final case class DeleteSpaceRequest(domainId: DomainId, spaceName: SpaceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest = {
    import DeleteSpaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .spaceName(SpaceName.unwrap(spaceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteSpaceRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteSpaceRequest.wrap(buildAwsValue())
}
object DeleteSpaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteSpaceRequest =
      zio.aws.sagemaker.model.DeleteSpaceRequest(domainId, spaceName)
    def domainId: DomainId
    def spaceName: SpaceName
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getSpaceName: ZIO[Any, Nothing, SpaceName] = ZIO.succeed(spaceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest
  ) extends zio.aws.sagemaker.model.DeleteSpaceRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val spaceName: SpaceName =
      zio.aws.sagemaker.model.primitives.SpaceName(impl.spaceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest
  ): zio.aws.sagemaker.model.DeleteSpaceRequest.ReadOnly = new Wrapper(impl)
}
