package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters._
final case class DeleteModelCardRequest(modelCardName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest = {
    import DeleteModelCardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest
      .builder()
      .modelCardName(EntityName.unwrap(modelCardName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteModelCardRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteModelCardRequest.wrap(buildAwsValue())
}
object DeleteModelCardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteModelCardRequest =
      zio.aws.sagemaker.model.DeleteModelCardRequest(modelCardName)
    def modelCardName: EntityName
    def getModelCardName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest
  ) extends zio.aws.sagemaker.model.DeleteModelCardRequest.ReadOnly {
    override val modelCardName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelCardName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest
  ): zio.aws.sagemaker.model.DeleteModelCardRequest.ReadOnly = new Wrapper(impl)
}
