package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.InferenceExperimentArn
import scala.jdk.CollectionConverters._
final case class DeleteInferenceExperimentResponse(
    inferenceExperimentArn: InferenceExperimentArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentResponse = {
    import DeleteInferenceExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentResponse
      .builder()
      .inferenceExperimentArn(
        InferenceExperimentArn.unwrap(inferenceExperimentArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DeleteInferenceExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteInferenceExperimentResponse
      .wrap(buildAwsValue())
}
object DeleteInferenceExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteInferenceExperimentResponse =
      zio.aws.sagemaker.model
        .DeleteInferenceExperimentResponse(inferenceExperimentArn)
    def inferenceExperimentArn: InferenceExperimentArn
    def getInferenceExperimentArn: ZIO[Any, Nothing, InferenceExperimentArn] =
      ZIO.succeed(inferenceExperimentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentResponse
  ) extends zio.aws.sagemaker.model.DeleteInferenceExperimentResponse.ReadOnly {
    override val inferenceExperimentArn: InferenceExperimentArn =
      zio.aws.sagemaker.model.primitives
        .InferenceExperimentArn(impl.inferenceExperimentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentResponse
  ): zio.aws.sagemaker.model.DeleteInferenceExperimentResponse.ReadOnly =
    new Wrapper(impl)
}
