package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{EndpointConfigName, EndpointName}
import scala.jdk.CollectionConverters._
final case class CreateEndpointRequest(
    endpointName: EndpointName,
    endpointConfigName: EndpointConfigName,
    deploymentConfig: Optional[zio.aws.sagemaker.model.DeploymentConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest = {
    import CreateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest
      .builder()
      .endpointName(EndpointName.unwrap(endpointName): java.lang.String)
      .endpointConfigName(
        EndpointConfigName.unwrap(endpointConfigName): java.lang.String
      )
      .optionallyWith(deploymentConfig.map(value => value.buildAwsValue()))(
        _.deploymentConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateEndpointRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateEndpointRequest.wrap(buildAwsValue())
}
object CreateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateEndpointRequest =
      zio.aws.sagemaker.model.CreateEndpointRequest(
        endpointName,
        endpointConfigName,
        deploymentConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def endpointName: EndpointName
    def endpointConfigName: EndpointConfigName
    def deploymentConfig
        : Optional[zio.aws.sagemaker.model.DeploymentConfig.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getEndpointName: ZIO[Any, Nothing, EndpointName] =
      ZIO.succeed(endpointName)
    def getEndpointConfigName: ZIO[Any, Nothing, EndpointConfigName] =
      ZIO.succeed(endpointConfigName)
    def getDeploymentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DeploymentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentConfig", deploymentConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest
  ) extends zio.aws.sagemaker.model.CreateEndpointRequest.ReadOnly {
    override val endpointName: EndpointName =
      zio.aws.sagemaker.model.primitives.EndpointName(impl.endpointName())
    override val endpointConfigName: EndpointConfigName =
      zio.aws.sagemaker.model.primitives
        .EndpointConfigName(impl.endpointConfigName())
    override val deploymentConfig
        : Optional[zio.aws.sagemaker.model.DeploymentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfig())
        .map(value => zio.aws.sagemaker.model.DeploymentConfig.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest
  ): zio.aws.sagemaker.model.CreateEndpointRequest.ReadOnly = new Wrapper(impl)
}
