package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{
  StringParameterValue,
  ExperimentDescription,
  String256,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters._
final case class CreateActionRequest(
    actionName: ExperimentEntityName,
    source: zio.aws.sagemaker.model.ActionSource,
    actionType: String256,
    description: Optional[ExperimentDescription] = Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.ActionStatus] = Optional.Absent,
    properties: Optional[Map[StringParameterValue, StringParameterValue]] =
      Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sagemaker.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateActionRequest = {
    import CreateActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateActionRequest
      .builder()
      .actionName(ExperimentEntityName.unwrap(actionName): java.lang.String)
      .source(source.buildAwsValue())
      .actionType(String256.unwrap(actionType): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ExperimentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (StringParameterValue.unwrap(
                key
              ): java.lang.String) -> (StringParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateActionRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateActionRequest.wrap(buildAwsValue())
}
object CreateActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateActionRequest =
      zio.aws.sagemaker.model.CreateActionRequest(
        actionName,
        source.asEditable,
        actionType,
        description.map(value => value),
        status.map(value => value),
        properties.map(value => value),
        metadataProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def actionName: ExperimentEntityName
    def source: zio.aws.sagemaker.model.ActionSource.ReadOnly
    def actionType: String256
    def description: Optional[ExperimentDescription]
    def status: Optional[zio.aws.sagemaker.model.ActionStatus]
    def properties: Optional[Map[StringParameterValue, StringParameterValue]]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getActionName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(actionName)
    def getSource
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ActionSource.ReadOnly] =
      ZIO.succeed(source)
    def getActionType: ZIO[Any, Nothing, String256] = ZIO.succeed(actionType)
    def getDescription: ZIO[Any, AwsError, ExperimentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.sagemaker.model.ActionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProperties
        : ZIO[Any, AwsError, Map[StringParameterValue, StringParameterValue]] =
      AwsError.unwrapOptionField("properties", properties)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateActionRequest
  ) extends zio.aws.sagemaker.model.CreateActionRequest.ReadOnly {
    override val actionName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.actionName())
    override val source: zio.aws.sagemaker.model.ActionSource.ReadOnly =
      zio.aws.sagemaker.model.ActionSource.wrap(impl.source())
    override val actionType: String256 =
      zio.aws.sagemaker.model.primitives.String256(impl.actionType())
    override val description: Optional[ExperimentDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentDescription(value)
        )
    override val status: Optional[zio.aws.sagemaker.model.ActionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.ActionStatus.wrap(value))
    override val properties
        : Optional[Map[StringParameterValue, StringParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives
                .StringParameterValue(key) -> zio.aws.sagemaker.model.primitives
                .StringParameterValue(value)
            })
            .toMap
        )
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val tags: Optional[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateActionRequest
  ): zio.aws.sagemaker.model.CreateActionRequest.ReadOnly = new Wrapper(impl)
}
