package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait ClarifyFeatureType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType
}
object ClarifyFeatureType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType
  ): zio.aws.sagemaker.model.ClarifyFeatureType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType.NUMERICAL =>
      val r = numerical
      r
    case software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType.CATEGORICAL =>
      val r = categorical
      r
    case software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType.TEXT =>
      val r = text
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ClarifyFeatureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType =
      software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType.UNKNOWN_TO_SDK_VERSION
  }
  case object numerical extends zio.aws.sagemaker.model.ClarifyFeatureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType =
      software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType.NUMERICAL
  }
  case object categorical extends zio.aws.sagemaker.model.ClarifyFeatureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType =
      software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType.CATEGORICAL
  }
  case object text extends zio.aws.sagemaker.model.ClarifyFeatureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType =
      software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType.TEXT
  }
}
