package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxAutoMLJobRuntimeInSeconds,
  MaxRuntimePerTrainingJobInSeconds,
  MaxCandidates
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AutoMLJobCompletionCriteria(
    maxCandidates: Optional[MaxCandidates] = Optional.Absent,
    maxRuntimePerTrainingJobInSeconds: Optional[
      MaxRuntimePerTrainingJobInSeconds
    ] = Optional.Absent,
    maxAutoMLJobRuntimeInSeconds: Optional[MaxAutoMLJobRuntimeInSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria = {
    import AutoMLJobCompletionCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria
      .builder()
      .optionallyWith(
        maxCandidates.map(value => MaxCandidates.unwrap(value): Integer)
      )(_.maxCandidates)
      .optionallyWith(
        maxRuntimePerTrainingJobInSeconds.map(value =>
          MaxRuntimePerTrainingJobInSeconds.unwrap(value): Integer
        )
      )(_.maxRuntimePerTrainingJobInSeconds)
      .optionallyWith(
        maxAutoMLJobRuntimeInSeconds.map(value =>
          MaxAutoMLJobRuntimeInSeconds.unwrap(value): Integer
        )
      )(_.maxAutoMLJobRuntimeInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly =
    zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.wrap(buildAwsValue())
}
object AutoMLJobCompletionCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLJobCompletionCriteria =
      zio.aws.sagemaker.model.AutoMLJobCompletionCriteria(
        maxCandidates.map(value => value),
        maxRuntimePerTrainingJobInSeconds.map(value => value),
        maxAutoMLJobRuntimeInSeconds.map(value => value)
      )
    def maxCandidates: Optional[MaxCandidates]
    def maxRuntimePerTrainingJobInSeconds
        : Optional[MaxRuntimePerTrainingJobInSeconds]
    def maxAutoMLJobRuntimeInSeconds: Optional[MaxAutoMLJobRuntimeInSeconds]
    def getMaxCandidates: ZIO[Any, AwsError, MaxCandidates] =
      AwsError.unwrapOptionField("maxCandidates", maxCandidates)
    def getMaxRuntimePerTrainingJobInSeconds
        : ZIO[Any, AwsError, MaxRuntimePerTrainingJobInSeconds] =
      AwsError.unwrapOptionField(
        "maxRuntimePerTrainingJobInSeconds",
        maxRuntimePerTrainingJobInSeconds
      )
    def getMaxAutoMLJobRuntimeInSeconds
        : ZIO[Any, AwsError, MaxAutoMLJobRuntimeInSeconds] =
      AwsError.unwrapOptionField(
        "maxAutoMLJobRuntimeInSeconds",
        maxAutoMLJobRuntimeInSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria
  ) extends zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly {
    override val maxCandidates: Optional[MaxCandidates] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCandidates())
      .map(value => zio.aws.sagemaker.model.primitives.MaxCandidates(value))
    override val maxRuntimePerTrainingJobInSeconds
        : Optional[MaxRuntimePerTrainingJobInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRuntimePerTrainingJobInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .MaxRuntimePerTrainingJobInSeconds(value)
      )
    override val maxAutoMLJobRuntimeInSeconds
        : Optional[MaxAutoMLJobRuntimeInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAutoMLJobRuntimeInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MaxAutoMLJobRuntimeInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLJobCompletionCriteria
  ): zio.aws.sagemaker.model.AutoMLJobCompletionCriteria.ReadOnly = new Wrapper(
    impl
  )
}
