package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MLFramework,
  ReleaseNotes,
  ImageVersionNumber,
  ImageName,
  Horovod,
  SageMakerImageVersionAlias,
  ProgrammingLang
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateImageVersionRequest(
    imageName: ImageName,
    alias: Optional[SageMakerImageVersionAlias] = Optional.Absent,
    version: Optional[ImageVersionNumber] = Optional.Absent,
    aliasesToAdd: Optional[Iterable[SageMakerImageVersionAlias]] =
      Optional.Absent,
    aliasesToDelete: Optional[Iterable[SageMakerImageVersionAlias]] =
      Optional.Absent,
    vendorGuidance: Optional[zio.aws.sagemaker.model.VendorGuidance] =
      Optional.Absent,
    jobType: Optional[zio.aws.sagemaker.model.JobType] = Optional.Absent,
    mlFramework: Optional[MLFramework] = Optional.Absent,
    programmingLang: Optional[ProgrammingLang] = Optional.Absent,
    processor: Optional[zio.aws.sagemaker.model.Processor] = Optional.Absent,
    horovod: Optional[Horovod] = Optional.Absent,
    releaseNotes: Optional[ReleaseNotes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionRequest = {
    import UpdateImageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionRequest
      .builder()
      .imageName(ImageName.unwrap(imageName): java.lang.String)
      .optionallyWith(
        alias.map(value =>
          SageMakerImageVersionAlias.unwrap(value): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        version.map(value => ImageVersionNumber.unwrap(value): Integer)
      )(_.version)
      .optionallyWith(
        aliasesToAdd.map(value =>
          value.map { item =>
            SageMakerImageVersionAlias.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aliasesToAdd)
      .optionallyWith(
        aliasesToDelete.map(value =>
          value.map { item =>
            SageMakerImageVersionAlias.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aliasesToDelete)
      .optionallyWith(vendorGuidance.map(value => value.unwrap))(
        _.vendorGuidance
      )
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(
        mlFramework.map(value => MLFramework.unwrap(value): java.lang.String)
      )(_.mlFramework)
      .optionallyWith(
        programmingLang.map(value =>
          ProgrammingLang.unwrap(value): java.lang.String
        )
      )(_.programmingLang)
      .optionallyWith(processor.map(value => value.unwrap))(_.processor)
      .optionallyWith(
        horovod.map(value => Horovod.unwrap(value): java.lang.Boolean)
      )(_.horovod)
      .optionallyWith(
        releaseNotes.map(value => ReleaseNotes.unwrap(value): java.lang.String)
      )(_.releaseNotes)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateImageVersionRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateImageVersionRequest.wrap(buildAwsValue())
}
object UpdateImageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateImageVersionRequest =
      zio.aws.sagemaker.model.UpdateImageVersionRequest(
        imageName,
        alias.map(value => value),
        version.map(value => value),
        aliasesToAdd.map(value => value),
        aliasesToDelete.map(value => value),
        vendorGuidance.map(value => value),
        jobType.map(value => value),
        mlFramework.map(value => value),
        programmingLang.map(value => value),
        processor.map(value => value),
        horovod.map(value => value),
        releaseNotes.map(value => value)
      )
    def imageName: ImageName
    def alias: Optional[SageMakerImageVersionAlias]
    def version: Optional[ImageVersionNumber]
    def aliasesToAdd: Optional[List[SageMakerImageVersionAlias]]
    def aliasesToDelete: Optional[List[SageMakerImageVersionAlias]]
    def vendorGuidance: Optional[zio.aws.sagemaker.model.VendorGuidance]
    def jobType: Optional[zio.aws.sagemaker.model.JobType]
    def mlFramework: Optional[MLFramework]
    def programmingLang: Optional[ProgrammingLang]
    def processor: Optional[zio.aws.sagemaker.model.Processor]
    def horovod: Optional[Horovod]
    def releaseNotes: Optional[ReleaseNotes]
    def getImageName: ZIO[Any, Nothing, ImageName] = ZIO.succeed(imageName)
    def getAlias: ZIO[Any, AwsError, SageMakerImageVersionAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getVersion: ZIO[Any, AwsError, ImageVersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getAliasesToAdd: ZIO[Any, AwsError, List[SageMakerImageVersionAlias]] =
      AwsError.unwrapOptionField("aliasesToAdd", aliasesToAdd)
    def getAliasesToDelete
        : ZIO[Any, AwsError, List[SageMakerImageVersionAlias]] =
      AwsError.unwrapOptionField("aliasesToDelete", aliasesToDelete)
    def getVendorGuidance
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VendorGuidance] =
      AwsError.unwrapOptionField("vendorGuidance", vendorGuidance)
    def getJobType: ZIO[Any, AwsError, zio.aws.sagemaker.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getMlFramework: ZIO[Any, AwsError, MLFramework] =
      AwsError.unwrapOptionField("mlFramework", mlFramework)
    def getProgrammingLang: ZIO[Any, AwsError, ProgrammingLang] =
      AwsError.unwrapOptionField("programmingLang", programmingLang)
    def getProcessor: ZIO[Any, AwsError, zio.aws.sagemaker.model.Processor] =
      AwsError.unwrapOptionField("processor", processor)
    def getHorovod: ZIO[Any, AwsError, Horovod] =
      AwsError.unwrapOptionField("horovod", horovod)
    def getReleaseNotes: ZIO[Any, AwsError, ReleaseNotes] =
      AwsError.unwrapOptionField("releaseNotes", releaseNotes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionRequest
  ) extends zio.aws.sagemaker.model.UpdateImageVersionRequest.ReadOnly {
    override val imageName: ImageName =
      zio.aws.sagemaker.model.primitives.ImageName(impl.imageName())
    override val alias: Optional[SageMakerImageVersionAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.sagemaker.model.primitives.SageMakerImageVersionAlias(value)
        )
    override val version: Optional[ImageVersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ImageVersionNumber(value)
      )
    override val aliasesToAdd: Optional[List[SageMakerImageVersionAlias]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliasesToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.SageMakerImageVersionAlias(item)
          }.toList
        )
    override val aliasesToDelete: Optional[List[SageMakerImageVersionAlias]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliasesToDelete())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.SageMakerImageVersionAlias(item)
          }.toList
        )
    override val vendorGuidance
        : Optional[zio.aws.sagemaker.model.VendorGuidance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorGuidance())
        .map(value => zio.aws.sagemaker.model.VendorGuidance.wrap(value))
    override val jobType: Optional[zio.aws.sagemaker.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.sagemaker.model.JobType.wrap(value))
    override val mlFramework: Optional[MLFramework] = zio.aws.core.internal
      .optionalFromNullable(impl.mlFramework())
      .map(value => zio.aws.sagemaker.model.primitives.MLFramework(value))
    override val programmingLang: Optional[ProgrammingLang] =
      zio.aws.core.internal
        .optionalFromNullable(impl.programmingLang())
        .map(value => zio.aws.sagemaker.model.primitives.ProgrammingLang(value))
    override val processor: Optional[zio.aws.sagemaker.model.Processor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processor())
        .map(value => zio.aws.sagemaker.model.Processor.wrap(value))
    override val horovod: Optional[Horovod] = zio.aws.core.internal
      .optionalFromNullable(impl.horovod())
      .map(value => zio.aws.sagemaker.model.primitives.Horovod(value))
    override val releaseNotes: Optional[ReleaseNotes] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseNotes())
      .map(value => zio.aws.sagemaker.model.primitives.ReleaseNotes(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionRequest
  ): zio.aws.sagemaker.model.UpdateImageVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
