package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait TrainingJobStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus
}
object TrainingJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus
  ): zio.aws.sagemaker.model.TrainingJobStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.TrainingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.sagemaker.model.TrainingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.sagemaker.model.TrainingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.TrainingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.FAILED
  }
  case object Stopping extends zio.aws.sagemaker.model.TrainingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.STOPPING
  }
  case object Stopped extends zio.aws.sagemaker.model.TrainingJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus =
      software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus.STOPPED
  }
}
