package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TensorBoardAppSettings(
    defaultResourceSpec: Optional[zio.aws.sagemaker.model.ResourceSpec] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TensorBoardAppSettings = {
    import TensorBoardAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TensorBoardAppSettings
      .builder()
      .optionallyWith(defaultResourceSpec.map(value => value.buildAwsValue()))(
        _.defaultResourceSpec
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly =
    zio.aws.sagemaker.model.TensorBoardAppSettings.wrap(buildAwsValue())
}
object TensorBoardAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TensorBoardAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TensorBoardAppSettings =
      zio.aws.sagemaker.model.TensorBoardAppSettings(
        defaultResourceSpec.map(value => value.asEditable)
      )
    def defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def getDefaultResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("defaultResourceSpec", defaultResourceSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TensorBoardAppSettings
  ) extends zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly {
    override val defaultResourceSpec
        : Optional[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultResourceSpec())
        .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TensorBoardAppSettings
  ): zio.aws.sagemaker.model.TensorBoardAppSettings.ReadOnly = new Wrapper(impl)
}
