package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxParallelTrainingJobs,
  MaxNumberOfTrainingJobs
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ResourceLimits(
    maxNumberOfTrainingJobs: Optional[MaxNumberOfTrainingJobs] =
      Optional.Absent,
    maxParallelTrainingJobs: MaxParallelTrainingJobs
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResourceLimits = {
    import ResourceLimits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResourceLimits
      .builder()
      .optionallyWith(
        maxNumberOfTrainingJobs.map(value =>
          MaxNumberOfTrainingJobs.unwrap(value): Integer
        )
      )(_.maxNumberOfTrainingJobs)
      .maxParallelTrainingJobs(
        MaxParallelTrainingJobs.unwrap(maxParallelTrainingJobs): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResourceLimits.ReadOnly =
    zio.aws.sagemaker.model.ResourceLimits.wrap(buildAwsValue())
}
object ResourceLimits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResourceLimits =
      zio.aws.sagemaker.model.ResourceLimits(
        maxNumberOfTrainingJobs.map(value => value),
        maxParallelTrainingJobs
      )
    def maxNumberOfTrainingJobs: Optional[MaxNumberOfTrainingJobs]
    def maxParallelTrainingJobs: MaxParallelTrainingJobs
    def getMaxNumberOfTrainingJobs
        : ZIO[Any, AwsError, MaxNumberOfTrainingJobs] = AwsError
      .unwrapOptionField("maxNumberOfTrainingJobs", maxNumberOfTrainingJobs)
    def getMaxParallelTrainingJobs: ZIO[Any, Nothing, MaxParallelTrainingJobs] =
      ZIO.succeed(maxParallelTrainingJobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ) extends zio.aws.sagemaker.model.ResourceLimits.ReadOnly {
    override val maxNumberOfTrainingJobs: Optional[MaxNumberOfTrainingJobs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxNumberOfTrainingJobs())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxNumberOfTrainingJobs(value)
        )
    override val maxParallelTrainingJobs: MaxParallelTrainingJobs =
      zio.aws.sagemaker.model.primitives
        .MaxParallelTrainingJobs(impl.maxParallelTrainingJobs())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceLimits
  ): zio.aws.sagemaker.model.ResourceLimits.ReadOnly = new Wrapper(impl)
}
