package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class ModelCardExportOutputConfig(s3OutputPath: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelCardExportOutputConfig = {
    import ModelCardExportOutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelCardExportOutputConfig
      .builder()
      .s3OutputPath(S3Uri.unwrap(s3OutputPath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly =
    zio.aws.sagemaker.model.ModelCardExportOutputConfig.wrap(buildAwsValue())
}
object ModelCardExportOutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelCardExportOutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelCardExportOutputConfig =
      zio.aws.sagemaker.model.ModelCardExportOutputConfig(s3OutputPath)
    def s3OutputPath: S3Uri
    def getS3OutputPath: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3OutputPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardExportOutputConfig
  ) extends zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly {
    override val s3OutputPath: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3OutputPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardExportOutputConfig
  ): zio.aws.sagemaker.model.ModelCardExportOutputConfig.ReadOnly = new Wrapper(
    impl
  )
}
