package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{MaxResults, NextToken, WorkforceName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWorkforcesRequest(
    sortBy: Optional[zio.aws.sagemaker.model.ListWorkforcesSortByOptions] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent,
    nameContains: Optional[WorkforceName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest = {
    import ListWorkforcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest
      .builder()
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nameContains.map(value => WorkforceName.unwrap(value): java.lang.String)
      )(_.nameContains)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListWorkforcesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListWorkforcesRequest.wrap(buildAwsValue())
}
object ListWorkforcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListWorkforcesRequest =
      zio.aws.sagemaker.model.ListWorkforcesRequest(
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nameContains.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def sortBy: Optional[zio.aws.sagemaker.model.ListWorkforcesSortByOptions]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def nameContains: Optional[WorkforceName]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ListWorkforcesSortByOptions
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNameContains: ZIO[Any, AwsError, WorkforceName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest
  ) extends zio.aws.sagemaker.model.ListWorkforcesRequest.ReadOnly {
    override val sortBy
        : Optional[zio.aws.sagemaker.model.ListWorkforcesSortByOptions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.ListWorkforcesSortByOptions.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nameContains: Optional[WorkforceName] = zio.aws.core.internal
      .optionalFromNullable(impl.nameContains())
      .map(value => zio.aws.sagemaker.model.primitives.WorkforceName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest
  ): zio.aws.sagemaker.model.ListWorkforcesRequest.ReadOnly = new Wrapper(impl)
}
