package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  StudioLifecycleConfigName,
  NextToken,
  MaxResults
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStudioLifecycleConfigsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    nameContains: Optional[StudioLifecycleConfigName] = Optional.Absent,
    appTypeEquals: Optional[
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    modifiedTimeBefore: Optional[Timestamp] = Optional.Absent,
    modifiedTimeAfter: Optional[Timestamp] = Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.StudioLifecycleConfigSortKey] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest = {
    import ListStudioLifecycleConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        nameContains.map(value =>
          StudioLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(appTypeEquals.map(value => value.unwrap))(_.appTypeEquals)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        modifiedTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedTimeBefore)
      .optionallyWith(
        modifiedTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedTimeAfter)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest
      .wrap(buildAwsValue())
}
object ListStudioLifecycleConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest =
      zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        nameContains.map(value => value),
        appTypeEquals.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        modifiedTimeBefore.map(value => value),
        modifiedTimeAfter.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def nameContains: Optional[StudioLifecycleConfigName]
    def appTypeEquals
        : Optional[zio.aws.sagemaker.model.StudioLifecycleConfigAppType]
    def creationTimeBefore: Optional[Timestamp]
    def creationTimeAfter: Optional[Timestamp]
    def modifiedTimeBefore: Optional[Timestamp]
    def modifiedTimeAfter: Optional[Timestamp]
    def sortBy: Optional[zio.aws.sagemaker.model.StudioLifecycleConfigSortKey]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNameContains: ZIO[Any, AwsError, StudioLifecycleConfigName] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getAppTypeEquals: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = AwsError.unwrapOptionField("appTypeEquals", appTypeEquals)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getModifiedTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedTimeBefore", modifiedTimeBefore)
    def getModifiedTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedTimeAfter", modifiedTimeAfter)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.StudioLifecycleConfigSortKey
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest
  ) extends zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val nameContains: Optional[StudioLifecycleConfigName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.StudioLifecycleConfigName(value)
        )
    override val appTypeEquals
        : Optional[zio.aws.sagemaker.model.StudioLifecycleConfigAppType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appTypeEquals())
        .map(value =>
          zio.aws.sagemaker.model.StudioLifecycleConfigAppType.wrap(value)
        )
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modifiedTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy
        : Optional[zio.aws.sagemaker.model.StudioLifecycleConfigSortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.StudioLifecycleConfigSortKey.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest
  ): zio.aws.sagemaker.model.ListStudioLifecycleConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
