package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  NextToken,
  Timestamp,
  Integer,
  MaxResults,
  EntityName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ListModelCardExportJobsRequest(
    modelCardName: EntityName,
    modelCardVersion: Optional[Integer] = Optional.Absent,
    creationTimeAfter: Optional[Timestamp] = Optional.Absent,
    creationTimeBefore: Optional[Timestamp] = Optional.Absent,
    modelCardExportJobNameContains: Optional[EntityName] = Optional.Absent,
    statusEquals: Optional[zio.aws.sagemaker.model.ModelCardExportJobStatus] =
      Optional.Absent,
    sortBy: Optional[zio.aws.sagemaker.model.ModelCardExportJobSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.ModelCardExportJobSortOrder] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest = {
    import ListModelCardExportJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest
      .builder()
      .modelCardName(EntityName.unwrap(modelCardName): java.lang.String)
      .optionallyWith(modelCardVersion.map(value => value: java.lang.Integer))(
        _.modelCardVersion
      )
      .optionallyWith(
        creationTimeAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        creationTimeBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        modelCardExportJobNameContains.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.modelCardExportJobNameContains)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListModelCardExportJobsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListModelCardExportJobsRequest.wrap(buildAwsValue())
}
object ListModelCardExportJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListModelCardExportJobsRequest =
      zio.aws.sagemaker.model.ListModelCardExportJobsRequest(
        modelCardName,
        modelCardVersion.map(value => value),
        creationTimeAfter.map(value => value),
        creationTimeBefore.map(value => value),
        modelCardExportJobNameContains.map(value => value),
        statusEquals.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def modelCardName: EntityName
    def modelCardVersion: Optional[Integer]
    def creationTimeAfter: Optional[Timestamp]
    def creationTimeBefore: Optional[Timestamp]
    def modelCardExportJobNameContains: Optional[EntityName]
    def statusEquals: Optional[zio.aws.sagemaker.model.ModelCardExportJobStatus]
    def sortBy: Optional[zio.aws.sagemaker.model.ModelCardExportJobSortBy]
    def sortOrder: Optional[zio.aws.sagemaker.model.ModelCardExportJobSortOrder]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getModelCardName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelCardName)
    def getModelCardVersion: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("modelCardVersion", modelCardVersion)
    def getCreationTimeAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getCreationTimeBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getModelCardExportJobNameContains: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField(
        "modelCardExportJobNameContains",
        modelCardExportJobNameContains
      )
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCardExportJobStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelCardExportJobSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelCardExportJobSortOrder
    ] = AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest
  ) extends zio.aws.sagemaker.model.ListModelCardExportJobsRequest.ReadOnly {
    override val modelCardName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelCardName())
    override val modelCardVersion: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.modelCardVersion())
      .map(value => value: Integer)
    override val creationTimeAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTimeBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val modelCardExportJobNameContains: Optional[EntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelCardExportJobNameContains())
        .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val statusEquals
        : Optional[zio.aws.sagemaker.model.ModelCardExportJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusEquals())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardExportJobStatus.wrap(value)
        )
    override val sortBy
        : Optional[zio.aws.sagemaker.model.ModelCardExportJobSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardExportJobSortBy.wrap(value)
        )
    override val sortOrder
        : Optional[zio.aws.sagemaker.model.ModelCardExportJobSortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value =>
          zio.aws.sagemaker.model.ModelCardExportJobSortOrder.wrap(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest
  ): zio.aws.sagemaker.model.ListModelCardExportJobsRequest.ReadOnly =
    new Wrapper(impl)
}
