package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HumanLoopRequestSource(
    awsManagedHumanLoopRequestSource: zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HumanLoopRequestSource = {
    import HumanLoopRequestSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HumanLoopRequestSource
      .builder()
      .awsManagedHumanLoopRequestSource(awsManagedHumanLoopRequestSource.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly =
    zio.aws.sagemaker.model.HumanLoopRequestSource.wrap(buildAwsValue())
}
object HumanLoopRequestSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HumanLoopRequestSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HumanLoopRequestSource =
      zio.aws.sagemaker.model
        .HumanLoopRequestSource(awsManagedHumanLoopRequestSource)
    def awsManagedHumanLoopRequestSource
        : zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource
    def getAwsManagedHumanLoopRequestSource: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource
    ] = ZIO.succeed(awsManagedHumanLoopRequestSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanLoopRequestSource
  ) extends zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly {
    override val awsManagedHumanLoopRequestSource
        : zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource =
      zio.aws.sagemaker.model.AwsManagedHumanLoopRequestSource
        .wrap(impl.awsManagedHumanLoopRequestSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanLoopRequestSource
  ): zio.aws.sagemaker.model.HumanLoopRequestSource.ReadOnly = new Wrapper(impl)
}
