package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class HumanLoopActivationConfig(
    humanLoopActivationConditionsConfig: zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConfig = {
    import HumanLoopActivationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConfig
      .builder()
      .humanLoopActivationConditionsConfig(
        humanLoopActivationConditionsConfig.buildAwsValue()
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly =
    zio.aws.sagemaker.model.HumanLoopActivationConfig.wrap(buildAwsValue())
}
object HumanLoopActivationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.HumanLoopActivationConfig =
      zio.aws.sagemaker.model.HumanLoopActivationConfig(
        humanLoopActivationConditionsConfig.asEditable
      )
    def humanLoopActivationConditionsConfig
        : zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig.ReadOnly
    def getHumanLoopActivationConditionsConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig.ReadOnly
    ] = ZIO.succeed(humanLoopActivationConditionsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConfig
  ) extends zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly {
    override val humanLoopActivationConditionsConfig
        : zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig.ReadOnly =
      zio.aws.sagemaker.model.HumanLoopActivationConditionsConfig
        .wrap(impl.humanLoopActivationConditionsConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.HumanLoopActivationConfig
  ): zio.aws.sagemaker.model.HumanLoopActivationConfig.ReadOnly = new Wrapper(
    impl
  )
}
