package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.PolicyString
import scala.jdk.CollectionConverters._
final case class GetModelPackageGroupPolicyResponse(
    resourcePolicy: PolicyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse = {
    import GetModelPackageGroupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse
      .builder()
      .resourcePolicy(PolicyString.unwrap(resourcePolicy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.ReadOnly =
    zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse
      .wrap(buildAwsValue())
}
object GetModelPackageGroupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse =
      zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse(resourcePolicy)
    def resourcePolicy: PolicyString
    def getResourcePolicy: ZIO[Any, Nothing, PolicyString] =
      ZIO.succeed(resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse
  ) extends zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.ReadOnly {
    override val resourcePolicy: PolicyString =
      zio.aws.sagemaker.model.primitives.PolicyString(impl.resourcePolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse
  ): zio.aws.sagemaker.model.GetModelPackageGroupPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
