package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DriftCheckExplainability(
    constraints: Optional[zio.aws.sagemaker.model.MetricsSource] =
      Optional.Absent,
    configFile: Optional[zio.aws.sagemaker.model.FileSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability = {
    import DriftCheckExplainability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability
      .builder()
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .optionallyWith(configFile.map(value => value.buildAwsValue()))(
        _.configFile
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly =
    zio.aws.sagemaker.model.DriftCheckExplainability.wrap(buildAwsValue())
}
object DriftCheckExplainability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DriftCheckExplainability =
      zio.aws.sagemaker.model.DriftCheckExplainability(
        constraints.map(value => value.asEditable),
        configFile.map(value => value.asEditable)
      )
    def constraints: Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def configFile: Optional[zio.aws.sagemaker.model.FileSource.ReadOnly]
    def getConstraints
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("constraints", constraints)
    def getConfigFile
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FileSource.ReadOnly] =
      AwsError.unwrapOptionField("configFile", configFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability
  ) extends zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly {
    override val constraints
        : Optional[zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
    override val configFile
        : Optional[zio.aws.sagemaker.model.FileSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configFile())
        .map(value => zio.aws.sagemaker.model.FileSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DriftCheckExplainability
  ): zio.aws.sagemaker.model.DriftCheckExplainability.ReadOnly = new Wrapper(
    impl
  )
}
