package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{DeviceName, EntityName}
import scala.jdk.CollectionConverters._
final case class DeregisterDevicesRequest(
    deviceFleetName: EntityName,
    deviceNames: Iterable[DeviceName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest = {
    import DeregisterDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .deviceNames(deviceNames.map { item =>
        DeviceName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeregisterDevicesRequest.ReadOnly =
    zio.aws.sagemaker.model.DeregisterDevicesRequest.wrap(buildAwsValue())
}
object DeregisterDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeregisterDevicesRequest =
      zio.aws.sagemaker.model
        .DeregisterDevicesRequest(deviceFleetName, deviceNames)
    def deviceFleetName: EntityName
    def deviceNames: List[DeviceName]
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getDeviceNames: ZIO[Any, Nothing, List[DeviceName]] =
      ZIO.succeed(deviceNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest
  ) extends zio.aws.sagemaker.model.DeregisterDevicesRequest.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val deviceNames: List[DeviceName] = impl
      .deviceNames()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.DeviceName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest
  ): zio.aws.sagemaker.model.DeregisterDevicesRequest.ReadOnly = new Wrapper(
    impl
  )
}
