package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.JsonPath
import scala.jdk.CollectionConverters._
final case class DataProcessing(
    inputFilter: Optional[JsonPath] = Optional.Absent,
    outputFilter: Optional[JsonPath] = Optional.Absent,
    joinSource: Optional[zio.aws.sagemaker.model.JoinSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataProcessing = {
    import DataProcessing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataProcessing
      .builder()
      .optionallyWith(
        inputFilter.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.inputFilter)
      .optionallyWith(
        outputFilter.map(value => JsonPath.unwrap(value): java.lang.String)
      )(_.outputFilter)
      .optionallyWith(joinSource.map(value => value.unwrap))(_.joinSource)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataProcessing.ReadOnly =
    zio.aws.sagemaker.model.DataProcessing.wrap(buildAwsValue())
}
object DataProcessing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataProcessing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataProcessing =
      zio.aws.sagemaker.model.DataProcessing(
        inputFilter.map(value => value),
        outputFilter.map(value => value),
        joinSource.map(value => value)
      )
    def inputFilter: Optional[JsonPath]
    def outputFilter: Optional[JsonPath]
    def joinSource: Optional[zio.aws.sagemaker.model.JoinSource]
    def getInputFilter: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("inputFilter", inputFilter)
    def getOutputFilter: ZIO[Any, AwsError, JsonPath] =
      AwsError.unwrapOptionField("outputFilter", outputFilter)
    def getJoinSource: ZIO[Any, AwsError, zio.aws.sagemaker.model.JoinSource] =
      AwsError.unwrapOptionField("joinSource", joinSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataProcessing
  ) extends zio.aws.sagemaker.model.DataProcessing.ReadOnly {
    override val inputFilter: Optional[JsonPath] = zio.aws.core.internal
      .optionalFromNullable(impl.inputFilter())
      .map(value => zio.aws.sagemaker.model.primitives.JsonPath(value))
    override val outputFilter: Optional[JsonPath] = zio.aws.core.internal
      .optionalFromNullable(impl.outputFilter())
      .map(value => zio.aws.sagemaker.model.primitives.JsonPath(value))
    override val joinSource: Optional[zio.aws.sagemaker.model.JoinSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.joinSource())
        .map(value => zio.aws.sagemaker.model.JoinSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataProcessing
  ): zio.aws.sagemaker.model.DataProcessing.ReadOnly = new Wrapper(impl)
}
