package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ClarifyHeader,
  ClarifyProbabilityIndex,
  ClarifyProbabilityAttribute,
  ClarifyFeaturesAttribute,
  ClarifyLabelAttribute,
  ClarifyMaxRecordCount,
  ClarifyMaxPayloadInMB,
  ClarifyContentTemplate,
  ClarifyLabelIndex
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ClarifyInferenceConfig(
    featuresAttribute: Optional[ClarifyFeaturesAttribute] = Optional.Absent,
    contentTemplate: Optional[ClarifyContentTemplate] = Optional.Absent,
    maxRecordCount: Optional[ClarifyMaxRecordCount] = Optional.Absent,
    maxPayloadInMB: Optional[ClarifyMaxPayloadInMB] = Optional.Absent,
    probabilityIndex: Optional[ClarifyProbabilityIndex] = Optional.Absent,
    labelIndex: Optional[ClarifyLabelIndex] = Optional.Absent,
    probabilityAttribute: Optional[ClarifyProbabilityAttribute] =
      Optional.Absent,
    labelAttribute: Optional[ClarifyLabelAttribute] = Optional.Absent,
    labelHeaders: Optional[Iterable[ClarifyHeader]] = Optional.Absent,
    featureHeaders: Optional[Iterable[ClarifyHeader]] = Optional.Absent,
    featureTypes: Optional[
      Iterable[zio.aws.sagemaker.model.ClarifyFeatureType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ClarifyInferenceConfig = {
    import ClarifyInferenceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ClarifyInferenceConfig
      .builder()
      .optionallyWith(
        featuresAttribute.map(value =>
          ClarifyFeaturesAttribute.unwrap(value): java.lang.String
        )
      )(_.featuresAttribute)
      .optionallyWith(
        contentTemplate.map(value =>
          ClarifyContentTemplate.unwrap(value): java.lang.String
        )
      )(_.contentTemplate)
      .optionallyWith(
        maxRecordCount.map(value =>
          ClarifyMaxRecordCount.unwrap(value): Integer
        )
      )(_.maxRecordCount)
      .optionallyWith(
        maxPayloadInMB.map(value =>
          ClarifyMaxPayloadInMB.unwrap(value): Integer
        )
      )(_.maxPayloadInMB)
      .optionallyWith(
        probabilityIndex.map(value =>
          ClarifyProbabilityIndex.unwrap(value): Integer
        )
      )(_.probabilityIndex)
      .optionallyWith(
        labelIndex.map(value => ClarifyLabelIndex.unwrap(value): Integer)
      )(_.labelIndex)
      .optionallyWith(
        probabilityAttribute.map(value =>
          ClarifyProbabilityAttribute.unwrap(value): java.lang.String
        )
      )(_.probabilityAttribute)
      .optionallyWith(
        labelAttribute.map(value =>
          ClarifyLabelAttribute.unwrap(value): java.lang.String
        )
      )(_.labelAttribute)
      .optionallyWith(
        labelHeaders.map(value =>
          value.map { item =>
            ClarifyHeader.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labelHeaders)
      .optionallyWith(
        featureHeaders.map(value =>
          value.map { item =>
            ClarifyHeader.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.featureHeaders)
      .optionallyWith(
        featureTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featureTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ClarifyInferenceConfig.ReadOnly =
    zio.aws.sagemaker.model.ClarifyInferenceConfig.wrap(buildAwsValue())
}
object ClarifyInferenceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ClarifyInferenceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ClarifyInferenceConfig =
      zio.aws.sagemaker.model.ClarifyInferenceConfig(
        featuresAttribute.map(value => value),
        contentTemplate.map(value => value),
        maxRecordCount.map(value => value),
        maxPayloadInMB.map(value => value),
        probabilityIndex.map(value => value),
        labelIndex.map(value => value),
        probabilityAttribute.map(value => value),
        labelAttribute.map(value => value),
        labelHeaders.map(value => value),
        featureHeaders.map(value => value),
        featureTypes.map(value => value)
      )
    def featuresAttribute: Optional[ClarifyFeaturesAttribute]
    def contentTemplate: Optional[ClarifyContentTemplate]
    def maxRecordCount: Optional[ClarifyMaxRecordCount]
    def maxPayloadInMB: Optional[ClarifyMaxPayloadInMB]
    def probabilityIndex: Optional[ClarifyProbabilityIndex]
    def labelIndex: Optional[ClarifyLabelIndex]
    def probabilityAttribute: Optional[ClarifyProbabilityAttribute]
    def labelAttribute: Optional[ClarifyLabelAttribute]
    def labelHeaders: Optional[List[ClarifyHeader]]
    def featureHeaders: Optional[List[ClarifyHeader]]
    def featureTypes: Optional[List[zio.aws.sagemaker.model.ClarifyFeatureType]]
    def getFeaturesAttribute: ZIO[Any, AwsError, ClarifyFeaturesAttribute] =
      AwsError.unwrapOptionField("featuresAttribute", featuresAttribute)
    def getContentTemplate: ZIO[Any, AwsError, ClarifyContentTemplate] =
      AwsError.unwrapOptionField("contentTemplate", contentTemplate)
    def getMaxRecordCount: ZIO[Any, AwsError, ClarifyMaxRecordCount] =
      AwsError.unwrapOptionField("maxRecordCount", maxRecordCount)
    def getMaxPayloadInMB: ZIO[Any, AwsError, ClarifyMaxPayloadInMB] =
      AwsError.unwrapOptionField("maxPayloadInMB", maxPayloadInMB)
    def getProbabilityIndex: ZIO[Any, AwsError, ClarifyProbabilityIndex] =
      AwsError.unwrapOptionField("probabilityIndex", probabilityIndex)
    def getLabelIndex: ZIO[Any, AwsError, ClarifyLabelIndex] =
      AwsError.unwrapOptionField("labelIndex", labelIndex)
    def getProbabilityAttribute
        : ZIO[Any, AwsError, ClarifyProbabilityAttribute] =
      AwsError.unwrapOptionField("probabilityAttribute", probabilityAttribute)
    def getLabelAttribute: ZIO[Any, AwsError, ClarifyLabelAttribute] =
      AwsError.unwrapOptionField("labelAttribute", labelAttribute)
    def getLabelHeaders: ZIO[Any, AwsError, List[ClarifyHeader]] =
      AwsError.unwrapOptionField("labelHeaders", labelHeaders)
    def getFeatureHeaders: ZIO[Any, AwsError, List[ClarifyHeader]] =
      AwsError.unwrapOptionField("featureHeaders", featureHeaders)
    def getFeatureTypes
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.ClarifyFeatureType]] =
      AwsError.unwrapOptionField("featureTypes", featureTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyInferenceConfig
  ) extends zio.aws.sagemaker.model.ClarifyInferenceConfig.ReadOnly {
    override val featuresAttribute: Optional[ClarifyFeaturesAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featuresAttribute())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyFeaturesAttribute(value)
        )
    override val contentTemplate: Optional[ClarifyContentTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentTemplate())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyContentTemplate(value)
        )
    override val maxRecordCount: Optional[ClarifyMaxRecordCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxRecordCount())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyMaxRecordCount(value)
        )
    override val maxPayloadInMB: Optional[ClarifyMaxPayloadInMB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxPayloadInMB())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyMaxPayloadInMB(value)
        )
    override val probabilityIndex: Optional[ClarifyProbabilityIndex] =
      zio.aws.core.internal
        .optionalFromNullable(impl.probabilityIndex())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyProbabilityIndex(value)
        )
    override val labelIndex: Optional[ClarifyLabelIndex] = zio.aws.core.internal
      .optionalFromNullable(impl.labelIndex())
      .map(value => zio.aws.sagemaker.model.primitives.ClarifyLabelIndex(value))
    override val probabilityAttribute: Optional[ClarifyProbabilityAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.probabilityAttribute())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyProbabilityAttribute(value)
        )
    override val labelAttribute: Optional[ClarifyLabelAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelAttribute())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ClarifyLabelAttribute(value)
        )
    override val labelHeaders: Optional[List[ClarifyHeader]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelHeaders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ClarifyHeader(item)
          }.toList
        )
    override val featureHeaders: Optional[List[ClarifyHeader]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureHeaders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.primitives.ClarifyHeader(item)
          }.toList
        )
    override val featureTypes
        : Optional[List[zio.aws.sagemaker.model.ClarifyFeatureType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ClarifyFeatureType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyInferenceConfig
  ): zio.aws.sagemaker.model.ClarifyInferenceConfig.ReadOnly = new Wrapper(impl)
}
