package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class AddTagsRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.sagemaker.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AddTagsRequest = {
    import AddTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AddTagsRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AddTagsRequest.ReadOnly =
    zio.aws.sagemaker.model.AddTagsRequest.wrap(buildAwsValue())
}
object AddTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AddTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AddTagsRequest =
      zio.aws.sagemaker.model.AddTagsRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.sagemaker.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AddTagsRequest
  ) extends zio.aws.sagemaker.model.AddTagsRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.sagemaker.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.sagemaker.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AddTagsRequest
  ): zio.aws.sagemaker.model.AddTagsRequest.ReadOnly = new Wrapper(impl)
}
