package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class ModelCardExportArtifacts(s3ExportArtifacts: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelCardExportArtifacts = {
    import ModelCardExportArtifacts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelCardExportArtifacts
      .builder()
      .s3ExportArtifacts(S3Uri.unwrap(s3ExportArtifacts): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelCardExportArtifacts.ReadOnly =
    zio.aws.sagemaker.model.ModelCardExportArtifacts.wrap(buildAwsValue())
}
object ModelCardExportArtifacts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelCardExportArtifacts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelCardExportArtifacts =
      zio.aws.sagemaker.model.ModelCardExportArtifacts(s3ExportArtifacts)
    def s3ExportArtifacts: S3Uri
    def getS3ExportArtifacts: ZIO[Any, Nothing, S3Uri] =
      ZIO.succeed(s3ExportArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardExportArtifacts
  ) extends zio.aws.sagemaker.model.ModelCardExportArtifacts.ReadOnly {
    override val s3ExportArtifacts: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3ExportArtifacts())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelCardExportArtifacts
  ): zio.aws.sagemaker.model.ModelCardExportArtifacts.ReadOnly = new Wrapper(
    impl
  )
}
