package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  PipelineExecutionArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPipelineExecutionStepsRequest(
    pipelineExecutionArn: Optional[PipelineExecutionArn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest = {
    import ListPipelineExecutionStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest
      .builder()
      .optionallyWith(
        pipelineExecutionArn.map(value =>
          PipelineExecutionArn.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest.ReadOnly =
    zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest
      .wrap(buildAwsValue())
}
object ListPipelineExecutionStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest =
      zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest(
        pipelineExecutionArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortOrder.map(value => value)
      )
    def pipelineExecutionArn: Optional[PipelineExecutionArn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def sortOrder: Optional[zio.aws.sagemaker.model.SortOrder]
    def getPipelineExecutionArn: ZIO[Any, AwsError, PipelineExecutionArn] =
      AwsError.unwrapOptionField("pipelineExecutionArn", pipelineExecutionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest
  ) extends zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest.ReadOnly {
    override val pipelineExecutionArn: Optional[PipelineExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.PipelineExecutionArn(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortOrder: Optional[zio.aws.sagemaker.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest
  ): zio.aws.sagemaker.model.ListPipelineExecutionStepsRequest.ReadOnly =
    new Wrapper(impl)
}
