package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName
import scala.jdk.CollectionConverters._
final case class DescribeNotebookInstanceLifecycleConfigRequest(
    notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest = {
    import DescribeNotebookInstanceLifecycleConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest
      .builder()
      .notebookInstanceLifecycleConfigName(
        NotebookInstanceLifecycleConfigName.unwrap(
          notebookInstanceLifecycleConfigName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest
      .wrap(buildAwsValue())
}
object DescribeNotebookInstanceLifecycleConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest =
      zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest(
        notebookInstanceLifecycleConfigName
      )
    def notebookInstanceLifecycleConfigName: NotebookInstanceLifecycleConfigName
    def getNotebookInstanceLifecycleConfigName
        : ZIO[Any, Nothing, NotebookInstanceLifecycleConfigName] =
      ZIO.succeed(notebookInstanceLifecycleConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest
  ) extends zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest.ReadOnly {
    override val notebookInstanceLifecycleConfigName
        : NotebookInstanceLifecycleConfigName =
      zio.aws.sagemaker.model.primitives.NotebookInstanceLifecycleConfigName(
        impl.notebookInstanceLifecycleConfigName()
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest
  ): zio.aws.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest.ReadOnly =
    new Wrapper(impl)
}
