package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ImageVersionArn
import scala.jdk.CollectionConverters._
final case class UpdateImageVersionResponse(
    imageVersionArn: Optional[ImageVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionResponse = {
    import UpdateImageVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionResponse
      .builder()
      .optionallyWith(
        imageVersionArn.map(value =>
          ImageVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateImageVersionResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateImageVersionResponse.wrap(buildAwsValue())
}
object UpdateImageVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateImageVersionResponse =
      zio.aws.sagemaker.model
        .UpdateImageVersionResponse(imageVersionArn.map(value => value))
    def imageVersionArn: Optional[ImageVersionArn]
    def getImageVersionArn: ZIO[Any, AwsError, ImageVersionArn] =
      AwsError.unwrapOptionField("imageVersionArn", imageVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionResponse
  ) extends zio.aws.sagemaker.model.UpdateImageVersionResponse.ReadOnly {
    override val imageVersionArn: Optional[ImageVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageVersionArn())
        .map(value => zio.aws.sagemaker.model.primitives.ImageVersionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionResponse
  ): zio.aws.sagemaker.model.UpdateImageVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
