package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters._
sealed trait RecommendationStepType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.RecommendationStepType
}
object RecommendationStepType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RecommendationStepType
  ): zio.aws.sagemaker.model.RecommendationStepType = value match {
    case software.amazon.awssdk.services.sagemaker.model.RecommendationStepType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RecommendationStepType.BENCHMARK =>
      val r = BENCHMARK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RecommendationStepType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationStepType =
      software.amazon.awssdk.services.sagemaker.model.RecommendationStepType.UNKNOWN_TO_SDK_VERSION
  }
  case object BENCHMARK extends zio.aws.sagemaker.model.RecommendationStepType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RecommendationStepType =
      software.amazon.awssdk.services.sagemaker.model.RecommendationStepType.BENCHMARK
  }
}
