package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.RecommendationFailureReason
import scala.jdk.CollectionConverters._
final case class RecommendationJobInferenceBenchmark(
    metrics: Optional[zio.aws.sagemaker.model.RecommendationMetrics] =
      Optional.Absent,
    endpointConfiguration: Optional[
      zio.aws.sagemaker.model.EndpointOutputConfiguration
    ] = Optional.Absent,
    modelConfiguration: zio.aws.sagemaker.model.ModelConfiguration,
    failureReason: Optional[RecommendationFailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobInferenceBenchmark = {
    import RecommendationJobInferenceBenchmark.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobInferenceBenchmark
      .builder()
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .optionallyWith(
        endpointConfiguration.map(value => value.buildAwsValue())
      )(_.endpointConfiguration)
      .modelConfiguration(modelConfiguration.buildAwsValue())
      .optionallyWith(
        failureReason.map(value =>
          RecommendationFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark
      .wrap(buildAwsValue())
}
object RecommendationJobInferenceBenchmark {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobInferenceBenchmark
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark =
      zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark(
        metrics.map(value => value.asEditable),
        endpointConfiguration.map(value => value.asEditable),
        modelConfiguration.asEditable,
        failureReason.map(value => value)
      )
    def metrics
        : Optional[zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly]
    def endpointConfiguration
        : Optional[zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly]
    def modelConfiguration: zio.aws.sagemaker.model.ModelConfiguration.ReadOnly
    def failureReason: Optional[RecommendationFailureReason]
    def getMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("metrics", metrics)
    def getEndpointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("endpointConfiguration", endpointConfiguration)
    def getModelConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelConfiguration.ReadOnly
    ] = ZIO.succeed(modelConfiguration)
    def getFailureReason: ZIO[Any, AwsError, RecommendationFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobInferenceBenchmark
  ) extends zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark.ReadOnly {
    override val metrics
        : Optional[zio.aws.sagemaker.model.RecommendationMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value => zio.aws.sagemaker.model.RecommendationMetrics.wrap(value))
    override val endpointConfiguration: Optional[
      zio.aws.sagemaker.model.EndpointOutputConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointConfiguration())
      .map(value =>
        zio.aws.sagemaker.model.EndpointOutputConfiguration.wrap(value)
      )
    override val modelConfiguration
        : zio.aws.sagemaker.model.ModelConfiguration.ReadOnly =
      zio.aws.sagemaker.model.ModelConfiguration.wrap(impl.modelConfiguration())
    override val failureReason: Optional[RecommendationFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.sagemaker.model.primitives.RecommendationFailureReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobInferenceBenchmark
  ): zio.aws.sagemaker.model.RecommendationJobInferenceBenchmark.ReadOnly =
    new Wrapper(impl)
}
