package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{KmsKeyId, DestinationS3Uri}
import scala.jdk.CollectionConverters._
final case class ProductionVariantCoreDumpConfig(
    destinationS3Uri: DestinationS3Uri,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProductionVariantCoreDumpConfig = {
    import ProductionVariantCoreDumpConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantCoreDumpConfig
      .builder()
      .destinationS3Uri(
        DestinationS3Uri.unwrap(destinationS3Uri): java.lang.String
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly =
    zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig
      .wrap(buildAwsValue())
}
object ProductionVariantCoreDumpConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProductionVariantCoreDumpConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig =
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig(
        destinationS3Uri,
        kmsKeyId.map(value => value)
      )
    def destinationS3Uri: DestinationS3Uri
    def kmsKeyId: Optional[KmsKeyId]
    def getDestinationS3Uri: ZIO[Any, Nothing, DestinationS3Uri] =
      ZIO.succeed(destinationS3Uri)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantCoreDumpConfig
  ) extends zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly {
    override val destinationS3Uri: DestinationS3Uri =
      zio.aws.sagemaker.model.primitives
        .DestinationS3Uri(impl.destinationS3Uri())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariantCoreDumpConfig
  ): zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly =
    new Wrapper(impl)
}
